@goto :setup
----------------------------------------------------------------------
vHandles.bat | https://ammaze.net/xywwweb/dls/vhandles.zip
C.L.Distefano rev. 2025-11-28

A utility for users who run XyWrite for DOS in vDosPlus,
  Wengier Wu's DOS emulator for Windows

See vHandles.txt for instructions on setup and use.
----------------------------------------------------------------------
:start

:: User Variables **************************************************
:: (1) Maximum handles before warning
set _maxHandles=500

:: (2) Optional: Keypress to quit/restart XyWrite
set _xyQuitKey=
REM set _xyQuitKey=^^{F5}
:: Keystrokes must follow AutoIt key naming conventions
::  Alphanumeric keys: abc
::  Other keys: {keyname}; e.g.: {F9}
::  Shifting keys: +:Shift !:Alt ^^:Ctrl #:Winkey
::   e.g.: for Ctrl-F5: ^^{F5} <== Note double circumflex ^^
:: See https://www.autoitscript.com/autoit3/docs/appendix/SendKeys.htm

:: Do not modify the following code
:: --------------------------------
if "z%_maxHandles%z"=="zz" set _maxHandles=500
set _vPID=
set _warned=FALSE
:a
call :isRunning %_xTarget%
if "%_vRunning%"=="TRUE" goto :c
cls
echo Sleeping ^(%_xTarget:~0,-4% not running^)
:b
%_sleep% 5 >nul
call :isRunning %_xTarget%
if "%_vRunning%"=="FALSE" goto :b
:c
if "z%_vPID%z"=="zz" call :getPID &goto :d
set _tmpPID=%_vPID%
call :getPID %_xTarget%
if "%_vPID%" NEQ "%_tmpPID%" set _warned=FALSE
:d
cls
echo Scanning %_xTarget:~0,-4% ...
call :getPID %_xTarget%
:e
call :isRunning %_xTarget%
if "%_vRunning%"=="FALSE" goto :a
for /f "tokens=2 delims=: " %%N in ('%_hexe% -p %_xTarget% -s ^| find "File"') do set /A _handles=%%N
%_echo% -e -n \e[1G\e[44mhandles: %_handles%\e[0m / \e[41mlimit: %_maxHandles%\e[0m                                                \b
:: Blank space!---^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
%_sleep% 1 >nul
if %_handles% LSS %_maxHandles% goto :e
if "%_warned%"=="TRUE" goto :a
%_msgbox% /t "%0" "Your vDosPlus session is about to crash!/Please save your files and restart vDosPLus now."
if "z%_xyQuitKey%z" NEQ "zz" %_sendkeys% "%_xTarget:~0,-4%" "%_xyQuitKey%"
set _warned=TRUE
%_sleep% 5 >nul
call :isRunning %_xTarget%
if "%_vRunning%"=="FALSE" set _vPID= &set _warned=FALSE
goto :a

:isRunning
set _vRunning=FALSE
for /F "tokens=1" %%A in ('%tasklist% /FI "IMAGENAME eq %1" /FI "STATUS eq RUNNING" ^| find /I ".exe"') do if /I "z%%Az"=="z%1z" set _vRunning=TRUE
exit /B

:getPID
set _vPID=
call :isRunning %1
if "%_vRunning%"=="FALSE" exit /B
for /F "tokens=2" %%A in ('%tasklist% /FI "IMAGENAME eq %1" ^| find /I ".exe"') do set _tmp=%%A
set _vPID=%_tmp%
exit /B

:trySetPath
if not "z%~$PATH:1z"=="zz" (set %2=%~$PATH:1) else (set %2=%1)
exit /B

:setup
@echo off
setlocal
call :trySetPath tasklist.exe tasklist
call :trySetPath wmic.exe wmic
set _arch=64
for /f "tokens=1 delims=-" %%A in ('%wmic% os get OSArchitecture ^| find "bit"') do if not "%%A"=="64" set _arch=
set _hexe=%~dp0handle%_arch%.exe
for %%F in (%_hexe% echos.exe msgbox.exe sendkeys.exe winmove.exe) do if not exist %%F echo Error: %%~nxF must be present in the directory with %0! &echo/ &echo Download https://ammaze.net/xywwweb/dls/vhandles.zip and unzip ALL&echo included files into the directory with vHandles.bat.&exit /B
set _echo=%~dp0echos.exe
set _msgbox=%~dp0msgbox.exe
set _sendkeys=%~dp0sendkeys.exe
set _sleep=timeout /t
set _xTarget=vDosPlus.exe
if "z%1z" NEQ "zz" set _xTarget=%1
if /I "z%_xTarget:~-4%z" NEQ "z.exez" set _xTarget=%_xTarget%.exe
%_echo% -e -n \e[?25l
if exist %~dp0winmove.exe %~dp0winmove.exe /T 1 1 470 105
goto :start
