// Generate a list of strong passphrases
// CLD rev. 2025-12-16
// Compile without optimization [-O] options

const std = @import("std");
const print = std.debug.print;
var gpa = std.heap.GeneralPurposeAllocator(.{}){};
const allocator = gpa.allocator();
const os_tag = @import("builtin").target.os.tag;
const dirname = switch(os_tag) {
	.windows => std.fs.path.dirnameWindows,
	else => std.fs.path.dirname,
};
const newline: []const u8 = switch (os_tag) {
	.windows => "\r\n",
	else => "\n",
};
const toUpper = std.ascii.toUpper;

const Config = struct {
	show_help: bool = false,
	max_len: usize = 30,
	min_len: usize = 20,
	punc1: u8 = '.',
	punc2: u8 = '.',

	pub fn initFromArgs(args: []const []const u8) !Config {
		var show_help: bool = false;
		var max_len: usize = 30;
		var min_len: usize = 20;
		var punc1: u8 = '.';
		var punc2: u8 = '.';
		var is_changed_maxlen: bool = false;
		var is_changed_punc1: bool = false;
		if (args.len > 1) {
			if (
					std.mem.eql(u8, args[1], "-?") or
					std.mem.eql(u8, args[1], "/?") or
					std.mem.eql(u8, args[1], "-h") or
					std.mem.eql(u8, args[1], "--help")) {
				show_help = true;
			}
			switch (isAllDigits(args[1][0..])) {
				true => {
					max_len = try std.fmt.parseInt(usize, args[1], 10);
					is_changed_maxlen = true;
				},
				else => {
					if (args[1].len == 1) {
						punc1 = args[1][0];
						is_changed_punc1 = true;
					}
				},
			}
		}
		for (2..5) |n| {
			if (args.len > n) {
				switch (isAllDigits(args[n][0..])) {
					true => switch (is_changed_maxlen) {
						true => {
							min_len = try std.fmt.parseInt(usize, args[n], 10);
						},
						else => {
							max_len = try std.fmt.parseInt(usize, args[n], 10);
							is_changed_maxlen = true;
						},
					},
					else => {
						if (args[n].len == 1) {
							switch (is_changed_punc1) {
								true => punc2 = args[n][0],
								else => {
									punc1 = args[n][0];
									is_changed_punc1 = true;
								},
							}
						}
					},
				}
			}
		}
		if (max_len < min_len) max_len = min_len;

		return Config {
			.show_help = show_help,
			.max_len = max_len,
			.min_len = min_len,
			.punc1 = punc1,
			.punc2 = punc2,
		};
	}
};

pub fn main() !void {
	const args = try std.process.argsAlloc(allocator);
	defer std.process.argsFree(allocator, args);
	const data = try std.fmt.allocPrint(allocator,
		"{s}", .{@embedFile("frases.dat")});
	defer allocator.free(data);
	const config: Config = try .initFromArgs(args);
	if (config.show_help) {
		showHelp(args[0]);
		return;
	}
	const max_len = config.max_len;
	const min_len = config.min_len;
	const punc1 = config.punc1;
	const punc2 = config.punc2;
	var seed: u64 = undefined;
	try std.posix.getrandom(std.mem.asBytes(&seed));
	var prng = std.Random.DefaultPrng.init(seed);
	const rand = prng.random();
	const sepr: u8 = '|';
	var lefts: [999]u8 = undefined;
	var rights: [999]u8 = undefined;
	var lo_num: u16 = 1001;
	var hi_num: u16 = 9999;
	var num_len: usize = 4;
	if (max_len < 25) {
		lo_num = 101;
		hi_num = 999;
		num_len = 3;
	}
	var number: u16 = undefined;
	var numbers: []const u8 = undefined;
	var idx1: usize = undefined;
	var idx2: usize = undefined;
	var tidxl1: usize = undefined;
	var tidxl2: usize = undefined;
	var tidxr1: usize = undefined;
	var tidxr2: usize = undefined;
	var coin_toss: bool = false;
	var index: usize = 0;
	const quantum: usize = 25;
	var lines_out = try std.fmt.allocPrint(allocator, "", .{});
	defer allocator.free(lines_out);
	for (1..999) |i| {
		_ = i;
		index += 1;
		if (index > quantum) break;
		lefts[0] = 0;
		rights[0] = 0;
		number = rand.intRangeAtMost(u16, lo_num, hi_num);
		numbers = try uintToSlice(u16, number);
		idx1 = rand.intRangeAtMost(usize, 1, data.len - 2);
		while (data[idx1] != sepr) idx1 -= 1;
		idx1 += 1;
		idx2 = idx1;
		while (data[idx2] != sepr) idx2 += 1;
		for (0..idx2 - idx1) |x| {
			if (x > 997) break;
			lefts[x] = data[x + idx1];
			lefts[x + 1] = 0;
		}
		tidxl1 = idx1;
		tidxl2 = idx2;
		idx1 = rand.intRangeAtMost(usize, 1, data.len - 2);
		while (data[idx1] != sepr) idx1 -= 1;
		idx1 += 1;
		idx2 = idx1;
		while (data[idx2] != sepr) idx2 += 1;
		for (0..idx2 - idx1) |x| {
			if (x > 997) break;
			rights[x] = data[x + idx1];
			rights[x + 1] = 0;
		}
		tidxr1 = idx1;
		tidxr2 = idx2;
		if (tidxl2 - tidxl1 + tidxr2 - tidxr1 > max_len - num_len) {
			index -|= 1;
			continue;
		}
		if (tidxl2 - tidxl1 + tidxr2 - tidxr1 < min_len - num_len) {
			index -|= 1;
			continue;
		}
		if (coin_toss) {
			lefts[0] = toUpper(lefts[0]);
		} else {
			rights[0] = toUpper(rights[0]);
		}
		coin_toss = !coin_toss;
		lines_out = try std.fmt.allocPrint(allocator,
			"{s}{s}{c}{s}{c}{s}{s}",
			.{lines_out, lefts[0..tidxl2 - tidxl1], punc1, numbers,
				punc2, rights[0..tidxr2 - tidxr1], newline});
	}
	//try fileWrite(".\\frases.txt", "test");
	try std.io.getStdOut().writer().writeAll(lines_out);
}

pub fn fileWrite(file_path: []const u8, data: []const u8) !void {
	if (data.len < 1) return;
	var file = try std.fs.cwd().createFile(file_path, .{});
	defer file.close();
	var buffered = std.io.bufferedWriter(file.writer());
	const writr = buffered.writer();
	try writr.writeAll(data);
 }

pub fn isAllDigits(str: []const u8) bool {
	if (str.len == 0) return false;
	for (str) |char| {
		if (char < '0' or char > '9') return false;
	}
	return true;
}

pub fn uintToSlice(comptime n_type: type, number: n_type) ![]const u8 {
	var buffer: [std.math.maxInt(n_type)]u8 = undefined;
	const str_out = try std.fmt.bufPrint(
		&buffer,
		"{d}", .{number});
	return str_out;
}

pub fn showHelp(prog_name: [:0]u8) void {
	print("\nGenerate a list of strong passphrases\n[C.L.Distefano rev. 2025-12-16]\n\nUsage\n-----\n{s} [NUMBER_1 [NUMBER_2]] [SEPARATOR-CHAR_1 [SEPARATOR-CHAR_2]]\n  NUMBER_1: maximum passphrase length (default = 30)\n  NUMBER_2: minimum passphrase length (default = 20)\n  SEPARATOR-CHAR_1, SEPARATOR-CHAR_2: characters used to separate\n    words from numbers in the passphrases (default = '.')\n\n\"{s} /?\" displays this help message\n\n", .{prog_name, prog_name});
	print("Tip: To view output in your text editor, command:\n  {s} > frases.txt && start frases.txt\n", .{prog_name});
}
